#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_OrderedTest : BaseTest 
	{
		
		private DataTable _dtOrderedTest;
		private DataTable _dtSpecimenTest;
		private DataTable _dtPatientSpecimen;
		private DataTable _dtBloodUnit;

		private BOL.OrderedTest _tstOT;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtSpecimenTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM SpecimenTest WHERE RecordStatusCode = 'A' AND OrderedTestGuid IN (SELECT OrderedTestGuid FROM OrderedTest WHERE PatientSpecimenGuid IS NOT NULL AND OrderableTestId IN (1,3,7,8,9,10,113,118,119) AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "')", false);
				if (this._dtSpecimenTest.Rows.Count == 0)
				{
					BOL.BloodUnit tmpUnit = DataCreator.CreateRBCBloodUnit(true);
					Guid patientGuid = DataCreator.GetRandomRecordGuid(TABLES.Patient.TableName, "");
					DataCreator.CreatePatientAssignment(tmpUnit.BloodUnitGuid, Guid.NewGuid(), true, true);

					Guid otGuid = DataCreator.GetRecordGuid("SELECT TOP 1 OrderedTestGuid FROM OrderedTest WHERE PatientSpecimenGuid IS NOT NULL ORDER BY LastUpdateDate DESC");
					Guid psGuid = DataCreator.GetRecordGuid("SELECT PatientSpecimenGuid FROM OrderedTest WHERE OrderedTestGuid = '" + otGuid.ToString() + "'");

					//Create a funky SpecimenTest
					DataTable newSpecimenTest = SprocHelper.GetInsertSpecimenTestSprocTable(Guid.NewGuid(), otGuid, psGuid, 1);
					new Common.StoredProcedure().TransactionalGetValue(SPROCS.InsertSpecimenTest.StoredProcName, newSpecimenTest);

					this._dtSpecimenTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM SpecimenTest WHERE RecordStatusCode = 'A' AND OrderedTestGuid IN (SELECT OrderedTestGuid FROM OrderedTest WHERE PatientSpecimenGuid IS NOT NULL AND OrderableTestId IN (1,3,7,8,9,10,113,118,119) AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "')", true);
				}

				//Get OrderedTest data ***********************************************************
				this._dtOrderedTest = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM OrderedTest WHERE OrderedTestGuid = '" + this._dtSpecimenTest.Rows[0][TABLES.OrderedTest.OrderedTestGuid].ToString() + "'", true);
				this._dtOrderedTest.Columns.Add(TABLES.PatientSpecimen.PatientGuid, typeof(System.Guid)); //need for OrderedTest creation since it derives from PatientOrder

				//Get PatientSpecimen data ***********************************************************
				this._dtPatientSpecimen = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM PatientSpecimen WHERE PatientSpecimenGuid = '" + this._dtOrderedTest.Rows[0][TABLES.OrderedTest.PatientSpecimenGuid].ToString() + "'", true);

				//Get BloodUnit data ***********************************************************
				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnit WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", false);
				if (this._dtBloodUnit.Rows.Count == 0)
				{
					DataCreator.CreateBloodUnit(false);
					this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnit WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				}
			
				this.RefreshData = false;
			}

			this._dtOrderedTest.Rows[0][TABLES.PatientSpecimen.PatientGuid] = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientGuid];
			this._tstOT = new BOL.OrderedTest(this._dtOrderedTest.Rows[0]);
			this._tstOT.OrderableTest = "XM";		//Needed for Invalidate
		}


		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.OrderedTest tmpOT = new BOL.OrderedTest(this._dtOrderedTest.Rows[0]);

			Assert.IsTrue(tmpOT.OrderedTestGuid == (System.Guid)this._dtOrderedTest.Rows[0][TABLES.OrderedTest.OrderedTestGuid]);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}
		
		[Test]
		public void Ctor_Guid_Guid_Pass()
		{
			System.Guid otGuid = (System.Guid)this._dtOrderedTest.Rows[0][TABLES.OrderedTest.OrderedTestGuid];
			System.Guid poGuid = (System.Guid)this._dtOrderedTest.Rows[0][TABLES.OrderedTest.PatientOrderGuid];

			BOL.OrderedTest tmpOT = new BOL.OrderedTest(otGuid, poGuid);

			Assert.IsNotNull(tmpOT);
			Assert.IsTrue(tmpOT.OrderedTestGuid == otGuid);
			Assert.IsTrue(tmpOT.PatientOrderGuid == poGuid);
		}

		[Test]
		[ExpectedException(typeof(IndexOutOfRangeException))]
		public void Ctor_Guid_Guid_Fail()
		{
			System.Guid otGuid = System.Guid.NewGuid();
			System.Guid poGuid = System.Guid.NewGuid();

			BOL.OrderedTest tmpOT = new BOL.OrderedTest(otGuid, poGuid);
		}

		[Test]
		public void SpecimenAccessionNumber_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();
			this._tstOT.SpecimenAccessionNumber = tstValue;

			Assert.IsTrue(this._tstOT.SpecimenAccessionNumber == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SpecimenAccessionNumber_Fail()
		{
		}

		[Test]
		public void OrderedTestGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();
			this._tstOT.OrderedTestGuid = tstValue;

			Assert.IsTrue(this._tstOT.OrderedTestGuid == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderedTestGuid_Fail()
		{
		}

		[Test]
		public void RelatedTestGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();
			this._tstOT.RelatedTestGuid = tstValue;

			Assert.IsTrue(this._tstOT.RelatedTestGuid == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RelatedTestGuid_Fail()
		{
		}

		[Test]
		public void RecordStatusCode_Pass()
		{
			Common.RecordStatusCode tstValue = Common.RecordStatusCode.Converted;
			this._tstOT.RecordStatusCode = tstValue;

			Assert.IsTrue(this._tstOT.RecordStatusCode == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusCode_Fail()
		{
		}
		
		[Test]
		public void LabTestId_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();
			this._tstOT.LabTestId = tstValue;

			Assert.IsTrue(this._tstOT.LabTestId == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LabTestId_Fail()
		{
		}

		[Test]
		public void RelatedComponentGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();
			this._tstOT.RelatedComponentGuid = tstValue;

			Assert.IsTrue(this._tstOT.RelatedComponentGuid == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RelatedComponentGuid_Fail()
		{
		}

		[Test]
		public void SpecimenTests_Pass()
		{
			DataTable tstValue = new DataTable(TABLES.SpecimenTest.TableName);
			this._tstOT.SpecimenTests = tstValue;

			Assert.IsTrue(this._tstOT.SpecimenTests == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SpecimenTests_Fail()
		{
		}

		[Test]
		public void BloodUnitTests_Pass()
		{
			DataTable tstValue = new DataTable(TABLES.OrderedUnit.TableName);
			this._tstOT.BloodUnitTests = tstValue;

			Assert.IsTrue(this._tstOT.BloodUnitTests == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodUnitTests_Fail()
		{
		}

		[Test]
		public void OrderableTest_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();
			this._tstOT.OrderableTest = tstValue;

			Assert.IsTrue(this._tstOT.OrderableTest == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderableTest_Fail()
		{
		}

		[Test]
		public void TaskStatusCode_Pass()
		{
			char tstValue = System.DateTime.Now.ToString()[0];
			this._tstOT.TaskStatusCode = tstValue;

			Assert.IsTrue(this._tstOT.TaskStatusCode == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TaskStatusCode_Fail()
		{
		}

		[Test]
		public void TaskStatusText_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();
			this._tstOT.TaskStatusText = tstValue;

			Assert.IsTrue(this._tstOT.TaskStatusText == tstValue);
		}
	
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TaskStatusText_Fail()
		{
		}

		[Test]
		public void RequiredResultsDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;
			this._tstOT.RequiredResultsDate = tstValue;

			Assert.IsTrue(this._tstOT.RequiredResultsDate == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RequiredResultsDate_Fail()
		{
		}

		[Test]
		public void CPRSOrderNumber_Pass()
		{
            string tstValue = DataCreator.GetNewCprsOrderNumber();
			this._tstOT.CPRSOrderNumber = tstValue;

			Assert.IsTrue(this._tstOT.CPRSOrderNumber == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CPRSOrderNumber_Fail()
		{
		}

		[Test]
		public void OrderableTestId_Pass()
		{
			int tstValue = new Random().Next();
			this._tstOT.OrderableTestId = tstValue;

			Assert.IsTrue(this._tstOT.OrderableTestId == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderableTestId_Fail()
		{
		}

		[Test]
		public void ReportableTestId_Pass()
		{
			int tstValue = new Random().Next();
			this._tstOT.ReportableTestId = tstValue;

			Assert.IsTrue(this._tstOT.ReportableTestId == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReportableTestId_Fail()
		{
		}

		[Test]
		public void OrderUrgencyCode_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();
			this._tstOT.OrderUrgencyCode = tstValue;

			Assert.IsTrue(this._tstOT.OrderUrgencyCode == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderUrgencyCode_Fail()
		{
		}

		[Test]
		public void OrderUrgencyText_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();
			this._tstOT.OrderUrgencyText = tstValue;

			Assert.IsTrue(this._tstOT.OrderUrgencyText == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderUrgencyText_Fail()
		{
		}

		[Test]
		public void OrderStatusCode_Pass()
		{
			Common.OrderStatus tstValue = Common.OrderStatus.Pending;
			this._tstOT.OrderStatusCode = tstValue;

			Assert.IsTrue(this._tstOT.OrderStatusCode == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderStatusCode_Fail()
		{
		}

		[Test]
		public void OrderStatusText_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();
			this._tstOT.OrderStatusText = tstValue;

			Assert.IsTrue(this._tstOT.OrderStatusText == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OrderStatusText_Fail()
		{
		}

		[Test]
		public void Specimen_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientSpecimenGuid];

			BOL.Specimen tstValue = new BOL.Specimen(unitGuid);
			this._tstOT.Specimen = tstValue;

			Assert.IsTrue(this._tstOT.Specimen == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Specimen_Fail()
		{
		}

		[Test]
		public void SpecimenStatusText_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();
			this._tstOT.SpecimenStatusText = tstValue;

			Assert.IsTrue(this._tstOT.SpecimenStatusText == tstValue);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SpecimenStatusText_Fail()
		{
		}

		[Test]
		public void VBECSOrderNumber_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();
			this._tstOT.VBECSOrderNumber = tstValue;

			Assert.IsTrue(this._tstOT.VBECSOrderNumber == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void VBECSOrderNumber_Fail()
		{
		}

		[Test]
		public void LabOrderNumber_Pass()
		{
			string tstValue = this._tstOT.LabOrderNumber;

			Assert.IsTrue(this._tstOT.LabOrderNumber == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LabOrderNumber_Fail()
		{
		}

		[Test]
		public void RowVersion_Pass()
		{
			byte[] tstValue = new byte[9];
			this._tstOT.RowVersion = tstValue;

			Assert.IsTrue(this._tstOT.RowVersion == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RowVersion_Fail()
		{
		}


		[Test]
		public void IsOrderedTestPending_Pass()
		{	
			bool retValue = BOL.OrderedTest.IsOrderedTestPending();
			Assert.IsTrue(true);		//Any value is acceptable
		}
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsOrderedTestPending_Fail()
		{			
		}

		[Test]
		public void GetOrderableTestList_Pass()
		{
			DataTable dtTest = BOL.OrderedTest.GetOrderableTestList();
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderableTestList_Fail()
		{
		}

		[Test]
		public void GetReorderableTestList_Pass()
		{
			DataTable dt = BOL.OrderedTest.GetReorderableTestList(1);
			Assert.IsTrue(dt.Rows.Count > 0);
		}
		[Test]
		public void GetReorderableTestList_Fail()
		{
			DataTable dt = BOL.OrderedTest.GetReorderableTestList(int.MinValue);
			Assert.IsTrue(dt.Rows.Count == 0);
		}

		[Test]
		public void GetTestingTaskList_Pass()
		{
			DataTable dtTest = BOL.OrderedTest.GetOrderableTestList();
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTestingTaskList_Fail()
		{
		}

		[Test]
		public void GetTaskStatusList_Pass()
		{
			DataTable dtTest = BOL.OrderedTest.GetTaskStatusList();
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTaskStatusList_Fail()
		{
		}


		[Test]
		public void GetOrderedTestsforSpecimen_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientSpecimenGuid];
			DataTable dtTest = BOL.OrderedTest.GetOrderedTestsforSpecimen(unitGuid);
	
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		public void GetOrderedTestsforSpecimen_Fail()
		{
			DataTable dtTest = BOL.OrderedTest.GetOrderedTestsforSpecimen(System.Guid.NewGuid());
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetQCResultsForOrderedTest_Pass()
		{
			DataTable dtTest = BOL.OrderedTest.GetQCResultsForOrderedTest(this._tstOT.OrderedTestGuid);
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		public void GetQCResultsForOrderedTest_Fail()
		{
			DataTable dtTest = BOL.OrderedTest.GetQCResultsForOrderedTest(System.Guid.NewGuid());
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void SaveTestResults_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			bool result = false;
			Common.LogonUser.LogonUserDUZ = "UnitTest";

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual("Patient does not exist", patientGuid, Guid.NewGuid().ToString());
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidAboRh = Guid.NewGuid();
			string insertOrderedTestAboRh = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestAboRh += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestAboRh += "VALUES (";
			insertOrderedTestAboRh += "'" + orderedTestGuidAboRh.ToString() + "',";
			insertOrderedTestAboRh += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestAboRh += "'1',";
			insertOrderedTestAboRh += "'A',";
			insertOrderedTestAboRh += "'N',";
            insertOrderedTestAboRh += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedTestAboRh += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestAboRh += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestAboRh += "'UnitTestUser',";
			insertOrderedTestAboRh += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidABS = Guid.NewGuid();
			string insertOrderedTestABS = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestABS += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestABS += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestABS += "VALUES (";
			insertOrderedTestABS += "'" + orderedTestGuidABS.ToString() + "',";
			insertOrderedTestABS += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestABS += "'3',";
			insertOrderedTestABS += "'A',";
			insertOrderedTestABS += "'P',";
            insertOrderedTestABS += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedTestABS += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestABS += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestABS += "'UnitTestUser',";
			insertOrderedTestABS += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidDAT = Guid.NewGuid();
			string insertOrderedTestDAT = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestDAT += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestDAT += "VALUES (";
			insertOrderedTestDAT += "'" + orderedTestGuidDAT.ToString() + "',";
			insertOrderedTestDAT += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestDAT += "'4',";
			insertOrderedTestDAT += "'A',";
			insertOrderedTestDAT += "'P',";
            insertOrderedTestDAT += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedTestDAT += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestDAT += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestDAT += "'UnitTestUser',";
			insertOrderedTestDAT += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidAGT = Guid.NewGuid();
			string insertOrderedTestAGT = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestAGT += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestAGT += "VALUES (";
			insertOrderedTestAGT += "'" + orderedTestGuidAGT.ToString() + "',";
			insertOrderedTestAGT += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestAGT += "'12',";
			insertOrderedTestAGT += "'A',";
			insertOrderedTestAGT += "'P',";
            insertOrderedTestAGT += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedTestAGT += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestAGT += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestAGT += "'UnitTestUser',";
			insertOrderedTestAGT += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidABID = Guid.NewGuid();
			string insertOrderedTestABID = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestABID += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestABID += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestABID += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestABID += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestABID += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestABID += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestABID += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestABID += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestABID += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestABID += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestABID += "VALUES (";
			insertOrderedTestABID += "'" + orderedTestGuidABID.ToString() + "',";
			insertOrderedTestABID += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestABID += "'8',";
			insertOrderedTestABID += "'C',";
			insertOrderedTestABID += "'C',";
            insertOrderedTestABID += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedTestABID += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestABID += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestABID += "'UnitTestUser',";
			insertOrderedTestABID += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO PATIENTSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid reagentGuid = Guid.NewGuid();
			string insertReagent = "INSERT INTO REAGENT (";
			insertReagent += TABLES.Reagent.ReagentGuid + ",";
			insertReagent += TABLES.Reagent.ReagentTypeId + ",";
			insertReagent += TABLES.Reagent.ReagentName + ",";
			insertReagent += TABLES.Reagent.LotNumber + ",";
			insertReagent += TABLES.Reagent.RecordStatusCode + ",";
			insertReagent += TABLES.PatientSpecimen.DivisionCode + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertReagent += "VALUES (";
			insertReagent += "'" + reagentGuid.ToString() + "',";
			insertReagent += "'1',";
			insertReagent += "'TestReagent',";
			insertReagent += "'53000',";
			insertReagent += "'"+ Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active)+"',";
			insertReagent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertReagent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertReagent += "'UnitTestUser',";
			insertReagent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedTestAboRh);
			UnitTestUtil.RunSQL(insertOrderedTestABS);
			UnitTestUtil.RunSQL(insertOrderedTestDAT);
			UnitTestUtil.RunSQL(insertOrderedTestAGT);
			UnitTestUtil.RunSQL(insertOrderedTestABID);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertReagent);

			byte[] rowVersionOrderedTestAboRh = (byte[])UnitTestUtil.RunSQLGetDataRow("SELECT RowVersion FROM OrderedTest WHERE OrderedTestGuid = '" + orderedTestGuidAboRh.ToString() + "'")[0];
			byte[] rowVersionOrderedTestABS = (byte[])UnitTestUtil.RunSQLGetDataRow("SELECT RowVersion FROM OrderedTest WHERE OrderedTestGuid = '" + orderedTestGuidABS.ToString() + "'")[0];
			byte[] rowVersionOrderedTestDAT = (byte[])UnitTestUtil.RunSQLGetDataRow("SELECT RowVersion FROM OrderedTest WHERE OrderedTestGuid = '" + orderedTestGuidDAT.ToString() + "'")[0];
			byte[] rowVersionOrderedTestAGT = (byte[])UnitTestUtil.RunSQLGetDataRow("SELECT RowVersion FROM OrderedTest WHERE OrderedTestGuid = '" + orderedTestGuidAGT.ToString() + "'")[0];
			byte[] rowVersionOrderedTestABID = (byte[])UnitTestUtil.RunSQLGetDataRow("SELECT RowVersion FROM OrderedTest WHERE OrderedTestGuid = '" + orderedTestGuidABID.ToString() + "'")[0];

			try
			{
				DataSet dsTestResults = new DataSet();

				DataTable dt = new DataTable("ABORh");

				dt.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
				dt.Columns.Add("AntiA", typeof(string));
				dt.Columns.Add("AntiB", typeof(string));
				dt.Columns.Add("AntiAB", typeof(string));
				dt.Columns.Add("A1Cells", typeof(string));
				dt.Columns.Add("BCells", typeof(string));
				dt.Columns.Add("AntiD", typeof(string));
				dt.Columns.Add("ControlD", typeof(string));			
				dt.Columns.Add("AboInterp", typeof(string));			
				dt.Columns.Add("RhInterp", typeof(string));			
				dt.Columns.Add("AboComment", typeof(string));
				dt.Columns.Add("RhComment", typeof(string));
				dt.Columns.Add("PatientGuid", typeof(Guid));
				dt.Columns.Add("PatientSpecimenGuid", typeof(Guid));
				dt.Columns.Add("OrderedTestGuid", typeof(Guid));
				dt.Columns.Add(TABLES.OrderableTest.OrderableTestId);
				dt.Columns.Add("InitialABO", typeof(string));
				dt.Columns.Add("InitialRh", typeof(string));
				dt.Columns.Add("SystemABO", typeof(string));
				dt.Columns.Add("SystemRh", typeof(string));
				dt.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
				dt.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
				dt.Columns.Add("AntiASave", typeof(bool));
				dt.Columns.Add("AntiBSave", typeof(bool));
				dt.Columns.Add("AntiABSave", typeof(bool));
				dt.Columns.Add("A1CellsSave", typeof(bool));
				dt.Columns.Add("BCellsSave", typeof(bool));
				dt.Columns.Add("AntiDSave", typeof(bool));
				dt.Columns.Add("ControlDSave", typeof(bool));			
				dt.Columns.Add("AboInterpSave", typeof(bool));			
				dt.Columns.Add("RhInterpSave", typeof(bool));	
				dt.Columns.Add("AntiAGuid", typeof(System.Guid));
				dt.Columns.Add("AntiBGuid", typeof(System.Guid));
				dt.Columns.Add("AntiABGuid", typeof(System.Guid));
				dt.Columns.Add("A1CellsGuid", typeof(System.Guid));
				dt.Columns.Add("BCellsGuid", typeof(System.Guid));
				dt.Columns.Add("AntiDGuid", typeof(System.Guid));
				dt.Columns.Add("ControlDGuid", typeof(System.Guid));			
				dt.Columns.Add("AboInterpGuid", typeof(System.Guid));			
				dt.Columns.Add("RhInterpGuid", typeof(System.Guid));
				dt.Columns.Add("AntiARowVersion", typeof(byte[]));
				dt.Columns.Add("AntiBRowVersion", typeof(byte[]));
				dt.Columns.Add("AntiABRowVersion", typeof(byte[]));
				dt.Columns.Add("A1CellsRowVersion", typeof(byte[]));
				dt.Columns.Add("BCellsRowVersion", typeof(byte[]));
				dt.Columns.Add("AntiDRowVersion", typeof(byte[]));
				dt.Columns.Add("ControlDRowVersion", typeof(byte[]));			
				dt.Columns.Add("AboInterpRowVersion", typeof(byte[]));			
				dt.Columns.Add("RhInterpRowVersion", typeof(byte[]));
				dt.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
				//dt.Columns.Add("CannedCommentID");	
				dt.Columns.Add("CannedCommentGuid");
				dt.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
				dt.Columns.Add(TABLES.Rack.RackGuid, typeof(System.Guid));
				dt.Columns.Add("CprsOrderNumber");
				dt.Columns.Add("AboRhInconclusiveException");
				dt.Columns.Add("AboRhDiscrepancyException");
				dt.Columns.Add("RepeatAboRhDiscrepancyException");

				DataRow dr = dt.NewRow();
				dr["AntiA"] = "2";
				dr["AntiB"] = "0";
				dr["AntiAB"] = "3";
				dr["A1Cells"] = "0";
				dr["BCells"] = "4";
				dr["AntiD"] = "2";
				dr["ControlD"] = "0";
				dr["AboInterp"] = "A";
				dr["RhInterp"] = "P";

				dr["AntiASave"] = true;
				dr["AntiBSave"] = true;
				dr["AntiABSave"] = true;
				dr["A1CellsSave"] = true;
				dr["BCellsSave"] = true;
				dr["AntiDSave"] = true;
				dr["ControlDSave"] = true;
				dr["AboInterpSave"] = true;
				dr["RhInterpSave"] = true;

				dr[ARTIFICIAL.PartiallyCompleted] = false;
				dr["PatientGuid"] = patientGuid;
				dr["PatientSpecimenGuid"] = patientSpecimenGuid;
				dr["OrderedTestGuid"] = orderedTestGuidAboRh;
				dr[TABLES.OrderableTest.OrderableTestId] = "1";
				dr[TABLES.SpecimenTest.CorrectedResultIndicator] = false;
				dr[ARTIFICIAL.OrderedTestRowVersion] = rowVersionOrderedTestAboRh;
                dr["CprsOrderNumber"] = DataCreator.GetNewCprsOrderNumber();
			
				dt.Rows.Add(dr);

				dsTestResults.Tables.Add(dt);

				DataTable dtABS = new DataTable("ABS");

				//Header information
				dtABS.Columns.Add(ARTIFICIAL.Indicator, typeof(String));
				dtABS.Columns.Add("ScreeningCells",typeof(String));
				dtABS.Columns.Add(ARTIFICIAL.IS, typeof(String));
				dtABS.Columns.Add(ARTIFICIAL.C37, typeof(String));
				dtABS.Columns.Add(ARTIFICIAL.AHG, typeof(String));
				dtABS.Columns.Add(ARTIFICIAL.CC, typeof(String));
				dtABS.Columns.Add("ABSInterp", typeof(String));			
				dtABS.Columns.Add("ABSComment", typeof(String));
				dtABS.Columns.Add("PatientGuid", typeof(Guid));
				dtABS.Columns.Add("PatientSpecimenGuid", typeof(Guid));
				dtABS.Columns.Add("OrderedTestGuid", typeof(Guid));
				dtABS.Columns.Add(TABLES.OrderableTest.OrderableTestId);
				dtABS.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(String));
				dtABS.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
				dtABS.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
				dtABS.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
				dtABS.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
				dtABS.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
				dtABS.Columns.Add("ABSInterpSave", typeof(bool));
				dtABS.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
			
				dtABS.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
				dtABS.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
				dtABS.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
				dtABS.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
				dtABS.Columns.Add("ABSInterpInterpGuid", typeof(Guid));

				dtABS.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
				dtABS.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
				dtABS.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
				dtABS.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
				dtABS.Columns.Add("ABSInterpRowVersion", typeof(byte[]));
				dtABS.Columns.Add(TABLES.Rack.RackGuid, typeof(System.Guid));
				dtABS.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
				dtABS.Columns.Add("CprsOrderNumber");

				DataRow drABS = dtABS.NewRow();
				drABS[ARTIFICIAL.IS] = "M";
				drABS[ARTIFICIAL.C37] = "";
				drABS[ARTIFICIAL.AHG] = "";
				drABS[ARTIFICIAL.CC] = "";
				drABS["ABSComment"] = "";
				drABS["ScreeningCells"] = "Auto";
				drABS["PatientGuid"] = patientGuid;
				drABS["PatientSpecimenGuid"] = patientSpecimenGuid;
				drABS["OrderedTestGuid"] = orderedTestGuidABS;
				drABS[TABLES.OrderableTest.OrderableTestId] = 3;
				drABS[ARTIFICIAL.ISSave] = true;
				drABS[ARTIFICIAL.C37Save] = true;
				drABS[ARTIFICIAL.AHGSave] = true;
				drABS[ARTIFICIAL.CCSave] = true;
				drABS["ABSInterpSave"] = true;
				drABS[TABLES.SpecimenTest.CorrectedResultIndicator] = true;
				drABS[ARTIFICIAL.PartiallyCompleted] = false;
				drABS[ARTIFICIAL.OrderedTestRowVersion] = rowVersionOrderedTestABS;
                drABS["CprsOrderNumber"] = DataCreator.GetNewCprsOrderNumber();

				dtABS.Rows.Add(drABS);

				dsTestResults.Tables.Add(dtABS);

				DataTable dtDAT = new DataTable("DAT");

				dtDAT.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
				dtDAT.Columns.Add("TestType", typeof(string));
				dtDAT.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
				dtDAT.Columns.Add(ARTIFICIAL.AHG, typeof(string));
				dtDAT.Columns.Add(ARTIFICIAL.CC, typeof(string));
				dtDAT.Columns.Add("AHGInterp", typeof(string));
				dtDAT.Columns.Add("AHGComment", typeof(string));
				dtDAT.Columns.Add("PatientGuid", typeof(Guid));
				dtDAT.Columns.Add("PatientSpecimenGuid", typeof(Guid));
				dtDAT.Columns.Add("OrderedTestGuid", typeof(Guid));
				dtDAT.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
				dtDAT.Columns.Add(TABLES.ReagentType.ReagentTypeId, typeof(int));
				dtDAT.Columns.Add("Manufacturer", typeof(string));
				dtDAT.Columns.Add("ExpirationDate", typeof(DateTime));
				dtDAT.Columns.Add(TABLES.OrderableTest.OrderableTestId);
				dtDAT.Columns.Add("SystemAHGInterp", typeof(string));
				dtDAT.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
				dtDAT.Columns.Add("LotNumberSave", typeof(bool));
				dtDAT.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
				dtDAT.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
				dtDAT.Columns.Add("AHGInterpSave", typeof(bool));
				//dt.Columns.Add("CannedCommentID");
				dtDAT.Columns.Add("CannedCommentGuid");
				dtDAT.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
				dtDAT.Columns.Add(ARTIFICIAL.AHGGuid, typeof(System.Guid));
				dtDAT.Columns.Add(ARTIFICIAL.CCGuid, typeof(System.Guid));
				dtDAT.Columns.Add("AHGInterpGuid", typeof(System.Guid));
				dtDAT.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
				dtDAT.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
				dtDAT.Columns.Add("AHGInterpRowVersion", typeof(byte[]));
				dtDAT.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
				dtDAT.Columns.Add(TABLES.Rack.RackGuid, typeof(System.Guid));
				dtDAT.Columns.Add("CprsOrderNumber");

				DataRow drDAT = dtDAT.NewRow();
				drDAT["PatientGuid"] = patientGuid;
				drDAT["PatientSpecimenGuid"] = patientSpecimenGuid;
				drDAT["OrderedTestGuid"] = orderedTestGuidDAT;
				drDAT[ARTIFICIAL.AHG] = "2";
				drDAT[ARTIFICIAL.CC] = "3";
				drDAT["AHGInterp"] = "";

				drDAT[ARTIFICIAL.AHGSave] = true;
				drDAT[ARTIFICIAL.CCSave] = true;
				drDAT["AHGInterpSave"] = true;

				drDAT[ARTIFICIAL.PartiallyCompleted] = true;
				drDAT[TABLES.OrderableTest.OrderableTestId] = "4";
				drDAT[TABLES.SpecimenTest.CorrectedResultIndicator] = true;
				drDAT[ARTIFICIAL.OrderedTestRowVersion] = rowVersionOrderedTestDAT;
				drDAT[TABLES.Reagent.ReagentGuid] = reagentGuid;
                drDAT["CprsOrderNumber"] = DataCreator.GetNewCprsOrderNumber();

				dtDAT.Rows.Add(drDAT);

				dsTestResults.Tables.Add(dtDAT);

				DataTable dtAGT = new DataTable("AGC");

				dtAGT.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
				dtAGT.Columns.Add("TestType", typeof(string));
				dtAGT.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
				dtAGT.Columns.Add(ARTIFICIAL.VialId);
				dtAGT.Columns.Add(ARTIFICIAL.IS, typeof(string));
				dtAGT.Columns.Add(ARTIFICIAL.RT, typeof(string));
				dtAGT.Columns.Add(ARTIFICIAL.C37, typeof(string));
				dtAGT.Columns.Add(ARTIFICIAL.AHG, typeof(string));
				dtAGT.Columns.Add(ARTIFICIAL.CC, typeof(string));
				dtAGT.Columns.Add(ARTIFICIAL.Interp, typeof(string));
				dtAGT.Columns.Add(ARTIFICIAL.Comment, typeof(string));
				dtAGT.Columns.Add("PatientGuid", typeof(Guid));
				dtAGT.Columns.Add("PatientSpecimenGuid", typeof(Guid));
				dtAGT.Columns.Add("OrderedTestGuid", typeof(Guid));
				dtAGT.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
				dtAGT.Columns.Add(TABLES.ReagentType.ReagentTypeId, typeof(int));
				dtAGT.Columns.Add("Manufacturer", typeof(string));
				dtAGT.Columns.Add("ExpirationDate", typeof(DateTime));
				dtAGT.Columns.Add(TABLES.OrderableTest.OrderableTestId);
				dtAGT.Columns.Add("SystemAHGInterp", typeof(string));
				dtAGT.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
				dtAGT.Columns.Add("LotNumberSave", typeof(bool));
				dtAGT.Columns.Add("VialIDSave", typeof(bool));
				dtAGT.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
				dtAGT.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
				dtAGT.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
				dtAGT.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
				dtAGT.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
				dtAGT.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
				dtAGT.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(int));
				dtAGT.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
				dtAGT.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
				dtAGT.Columns.Add(ARTIFICIAL.RTGuid, typeof(Guid));
				dtAGT.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
				dtAGT.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
				dtAGT.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
				dtAGT.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));

				dtAGT.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
				dtAGT.Columns.Add(ARTIFICIAL.RTRowVersion, typeof(byte[]));
				dtAGT.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
				dtAGT.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
				dtAGT.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
				dtAGT.Columns.Add(ARTIFICIAL.InterpRowVersion, typeof(byte[]));
				dtAGT.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
				dtAGT.Columns.Add(TABLES.Rack.RackGuid, typeof(System.Guid));
				dtAGT.Columns.Add("CprsOrderNumber");

				DataRow drAGT = dtAGT.NewRow();
				drAGT["PatientGuid"] = patientGuid;
				drAGT["PatientSpecimenGuid"] = patientSpecimenGuid;
				drAGT["OrderedTestGuid"] = orderedTestGuidAGT;
				drAGT[ARTIFICIAL.VialId] = "1";
				drAGT[ARTIFICIAL.AHG] = "2";
				drAGT[ARTIFICIAL.CC] = "3";
				drAGT[ARTIFICIAL.Interp] = "P";

				drAGT["VialIDSave"] = true;
				drAGT[ARTIFICIAL.AHGSave] = true;
				drAGT[ARTIFICIAL.CCSave] = true;
				drAGT[ARTIFICIAL.InterpSave] = true;

				drAGT[ARTIFICIAL.PartiallyCompleted] = true;
				drAGT[TABLES.OrderableTest.OrderableTestId] = "12";
				drAGT[TABLES.ReactivityPhase.ReactivityPhaseCode] = (int)Common.ReactivityPhase.AHGandCC;
				drAGT["TestType"] = "Patient";
				drAGT[TABLES.SpecimenTest.CorrectedResultIndicator] = true;
				drAGT[ARTIFICIAL.OrderedTestRowVersion] = rowVersionOrderedTestAGT;
				drAGT[TABLES.Reagent.ReagentGuid] = reagentGuid;
                drAGT["CprsOrderNumber"] = DataCreator.GetNewCprsOrderNumber();

				dtAGT.Rows.Add(drAGT);

				dsTestResults.Tables.Add(dtAGT);

				DataTable dtAntibodyIDs = new DataTable("ABID");
				dtAntibodyIDs.Columns.Add("AntibodyTypeId", typeof(int));
				dtAntibodyIDs.Columns.Add("AntibodyTypeName");
				dtAntibodyIDs.Columns.Add("OffsiteLocation");
				dtAntibodyIDs.Columns.Add("OffsiteCost", typeof(decimal));
				//dtAntibodyIDs.Columns.Add("CannedCommentID", typeof(int));
				dtAntibodyIDs.Columns.Add("CannedCommentGuid", typeof(Guid));
				dtAntibodyIDs.Columns.Add("TestComments");
				dtAntibodyIDs.Columns.Add("OrderedTestGuid", typeof(Guid));
				dtAntibodyIDs.Columns.Add("PatientSpecimenGuid", typeof(Guid));
				dtAntibodyIDs.Columns.Add("PatientGuid", typeof(Guid));
				dtAntibodyIDs.Columns.Add(TABLES.OrderableTest.OrderableTestId, typeof(int));
				dtAntibodyIDs.Columns.Add("OffsiteIndicator", typeof(bool));
				dtAntibodyIDs.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
				dtAntibodyIDs.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
				dtAntibodyIDs.Columns.Add("CprsOrderNumber");

				DataRow drAntibodyID = dtAntibodyIDs.NewRow();
				drAntibodyID["AntibodyTypeId"] = 29;
				drAntibodyID["AntibodyTypeName"] = "Anti-K";
				drAntibodyID["OffsiteLocation"] = "Kansas";
				drAntibodyID["OffsiteCost"] = 10;
				drAntibodyID["TestComments"] = "";
				drAntibodyID[TABLES.OrderableTest.OrderableTestId] = 8;
				drAntibodyID["PatientGuid"] = patientGuid;
				drAntibodyID["PatientSpecimenGuid"] = patientSpecimenGuid;
				drAntibodyID["OrderedTestGuid"] = orderedTestGuidABID;
				drAntibodyID["OffsiteIndicator"] = false;
				drAntibodyID[TABLES.SpecimenTest.CorrectedResultIndicator] = true;
				drAntibodyID[ARTIFICIAL.OrderedTestRowVersion] = rowVersionOrderedTestABID;

				dtAntibodyIDs.Rows.Add(drAntibodyID);

				dsTestResults.Tables.Add(dtAntibodyIDs);
				dsTestResults.Tables.Add(new DataTable("ABIDProcess"));

				DataTable dtRacks = DAL.Rack.GetDailyQCRacks(DateTime.Now);
				Common.LogonUser.LogonUserDivisionCode = UnitTestConfig.TestDivisionCode;
				ArrayList workloadProcessIds = new ArrayList();
				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfuseUnit);
				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitLogin);
				workloadProcessIds.Add(Common.WorkloadProcessID.TransfuseUnit);
				workloadProcessIds.Add(Common.WorkloadProcessID.UnitLogin);
				bool msg = false;
				result = BOL.OrderedTest.SaveTestResults(dsTestResults, new ArrayList(), DateTime.Now, "DNS   DobraK", Common.TestingMethod.Gel, Common.ReactivityPhase.All, (Guid)dtRacks.Rows[0][TABLES.Rack.RackGuid], "", false, Common.UpdateFunction.UnitTests,workloadProcessIds, Guid.NewGuid(), new ArrayList(), ref msg);
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM PATIENTTRANSFUSIONREQUIREMENT WHERE SPECIMENTESTGUID IN (SELECT SPECIMENTESTGUID FROM SPECIMENTEST WHERE PATIENTSPECIMENGUID = '" + patientSpecimenGuid.ToString() + "')");
				UnitTestUtil.RunSQL("DELETE FROM SPECIMENTEST WHERE PATIENTSPECIMENGUID = '" + patientSpecimenGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM PATIENTSPECIMEN WHERE PATIENTSPECIMENGUID = '" + patientSpecimenGuid.ToString() + "'");
			}

			Assert.IsTrue(result == true);
		}


		[Test]
		public void SaveTestResults_Fail()
		{
			bool result;
			
			try
			{
				Common.LogonUser.LogonUserDivisionCode = "XXX";
				bool msg = false;
				result = BOL.OrderedTest.SaveTestResults(null, new ArrayList(), DateTime.MinValue, "", Common.TestingMethod.Unknown, Common.ReactivityPhase.Unknown, Guid.Empty, "", false, Common.UpdateFunction.UnitTests, null, Guid.NewGuid(), new ArrayList(), ref msg);
			}
			catch
			{
				result = false;
			}

			Assert.IsTrue(result == false);
		}

	
		[Test]
		public void GetEmptyOrderedTestTableSchema_Pass()
		{
			DataTable dtTest = BOL.OrderedTest.GetEmptyOrderedTestTableSchema(true);
			Assert.AreEqual(25, dtTest.Columns.Count);
			Assert.AreEqual(0, dtTest.Rows.Count);
			Assert.AreEqual(TABLES.OrderedTest.TableName, dtTest.TableName);
		}

			
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptyOrderedTestTableSchema_Fail()
		{
		}

		[Test]
		public void InactivateTestResults_Pass()
		{
			this.RefreshData = true;

			BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Previously_recorded_results_inactivated, "UnitTest", Common.LogonUser.LogonUserName);
			exRep.GenerateExceptionPatientTestInactivated(this._tstOT, Common.LogonUser.LogonUserName);

			bool retValue = this._tstOT.InactivateTestResults(exRep, Common.UpdateFunction.UnitTests);
			Assert.IsTrue(retValue);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InactivateTestResults_Fail()
		{
		}

		[Test]
		public void InactivateTestResultsForOrderableTest_Pass()
		{
			this.RefreshData = true;

			BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Previously_recorded_results_inactivated, "UnitTest", Common.LogonUser.LogonUserName);
			exRep.GenerateExceptionPatientTestInactivated(this._tstOT, Common.LogonUser.LogonUserName);

			bool retValue = this._tstOT.InactivateTestResultsForOrderableTest(exRep, this._tstOT.OrderableTestId, Common.UpdateFunction.UnitTests);
			Assert.IsTrue(retValue);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InactivateTestResultsForOrderableTest_Fail()
		{
		}

		[Test]
		public void GetTestOrders_Pass()
		{
			DataTable dtTest = BOL.OrderedTest.GetTestOrders();

			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTestOrders_Fail()
		{
		}

		[Test]
		public void UpdateStatus_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			Common.LogonUser.LogonUserDUZ = "UnitTest";

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual("Patient does not exist", patientGuid, Guid.NewGuid().ToString());
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO PATIENTSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid orderedTestGuidAboRh = Guid.NewGuid();
			string insertOrderedTestAboRh = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestAboRh += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.PatientSpecimenGuid + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestAboRh += "VALUES (";
			insertOrderedTestAboRh += "'" + orderedTestGuidAboRh.ToString() + "',";
			insertOrderedTestAboRh += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestAboRh += "'1',";
			insertOrderedTestAboRh += "'A',";
			insertOrderedTestAboRh += "'N',";
			insertOrderedTestAboRh += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedTestAboRh += "'" + patientSpecimenGuid.ToString() + "',";
			insertOrderedTestAboRh += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestAboRh += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestAboRh += "'UnitTestUser',";
			insertOrderedTestAboRh += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertOrderedTestAboRh);

			BOL.OrderedTest tmpT = new BOL.OrderedTest(orderedTestGuidAboRh, patientOrderGuid);
			bool retValue  = tmpT.UpdateStatus('P','I',"Test 3263", Guid.Empty, "Test 3263",this._tstOT.CPRSOrderNumber,null, Common.UpdateFunction.UnitTests);
			
			Assert.IsTrue(retValue == true);
		}


		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void UpdateStatus_Fail()
		{
			DataTable dtTest = BOL.OrderedTest.GetTestOrders();
			if (dtTest.Rows.Count == 0)
			{
				DataCreator.CreateCrossmatchedBloodUnitTestData();
				dtTest = BOL.OrderedTest.GetTestOrders();
			}
			BOL.OrderedTest tmpOT = new BOL.OrderedTest(dtTest.Rows[0]);
			tmpOT.UpdateStatus('Z','Z',"Test 3264", Guid.Empty, "Test 3264",this._tstOT.CPRSOrderNumber,null, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void GetReagentTypeForOrderableTest_Pass()
		{
			this._tstOT.OrderableTestId = 12;
			BOL.ReagentType reagentType = (BOL.ReagentType) this._tstOT.GetReagentTypeForOrderableTest();
			
			Assert.IsTrue(reagentType != null);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReagentTypeForOrderableTest_Fail()
		{
		}
		
		[Test]
		public void SaveReflexTests_Pass()
		{

			Guid patientGuid;
			Guid patientSpecimenGuid;
			Guid parentComponentGuid;
			Guid patientTreatmentGuid;
			
			//Create array list of Ordered Tests (example of Component Order, orderable test is Repeat XM)
			int[] selectedTestsList = new int[1];
			selectedTestsList[0] = (int) Common.OrderableTest.RepeatXM;

			StringBuilder sSQL = new StringBuilder();
			sSQL.Append("SELECT TOP 1 PT.PatientGuid, PT.PatientTreatmentGuid, OrderedComponent.OrderedComponentGuid, OrderedComponent.PatientSpecimenGuid ");
			sSQL.Append("FROM PatientOrder INNER JOIN OrderedComponent ON PatientOrder.PatientOrderGuid = OrderedComponent.PatientOrderGuid ");
			sSQL.Append(" JOIN PatientTreatment PT ON PatientOrder.PatientTreatmentGuid = PT.PatientTreatmentGuid ");
			sSQL.Append("WHERE PatientOrder.DivisionCode = '");
			sSQL.Append(UnitTestConfig.TestDivisionCode);
			sSQL.Append("' AND EXISTS (Select 1 FROM OrderedUnit WHERE OrderedUnit.OrderedComponentGuid = OrderedComponent.OrderedComponentGuid ");
			sSQL.Append("AND OrderedUnit.CrossmatchRequiredIndicator = 1)");
			sSQL.Append(" AND PatientSpecimenGuid IS NOT NULL ");

			// instantiate the Connection and Command object
			DataRow drData = UnitTestUtil.RunSQLGetDataRow(sSQL.ToString());

			patientGuid = (Guid) drData[TABLES.Patient.PatientGuid];
			parentComponentGuid = (Guid) drData[TABLES.OrderedComponent.OrderedComponentGuid];
			patientSpecimenGuid = (Guid) drData[TABLES.PatientSpecimen.PatientSpecimenGuid];
			patientTreatmentGuid = (Guid) drData[TABLES.PatientTreatment.PatientTreatmentGuid];

			DataTable dtSelectedUnits = BOL.OrderedUnit.GetOrderedUnitsForRepeatXM(Guid.Empty, parentComponentGuid);
			
			if(patientGuid != Guid.Empty && parentComponentGuid != Guid.Empty 
				&& patientSpecimenGuid != Guid.Empty && patientTreatmentGuid != Guid.Empty )
			{
				bool result = BOL.OrderedTest.SaveReflexTests(selectedTestsList, dtSelectedUnits, new BOL.Specimen(patientSpecimenGuid), 
					patientTreatmentGuid, Guid.Empty,	parentComponentGuid, String.Empty, Common.UpdateFunction.UnitTests);
				Assert.IsTrue(result == true);
			}
		}

		[Test]
		public void SaveReflexTests_Fail()
		{
			bool result;
			
			try
			{
				Common.LogonUser.LogonUserDivisionCode = "XXX";
				//result = BOL.OrderedTest.SaveReflexTests(null, null, Guid.Empty, Guid.Empty, Guid.Empty, Guid.Empty, 0, "");
				result = BOL.OrderedTest.SaveReflexTests(null, null, null, Guid.Empty,Guid.Empty, Guid.Empty, "", Common.UpdateFunction.UnitTests );
			}
			catch
			{
				result = false;
			}

			Assert.IsTrue(result == false);
		}

		[Test]
		public void IsCprsOrderable_Pass()
		{
			DataTable dtData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 OrderableTestId FROM OrderableTest WHERE CprsOrderableItemID NOT IN (99,-1)",  true);

			int orderableId = (int)dtData.Rows[0][TABLES.OrderableTest.OrderableTestId];

			bool retValue = BOL.OrderedTest.IsCprsOrderable(orderableId);

			Assert.IsTrue(retValue);

		}

		[Test]
		public void IsCprsOrderable_Fail()
		{
			DataTable dtData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 OrderableTestId FROM OrderableTest WHERE CprsOrderableItemID IN (99,-1)",  false);

			if (dtData.Rows.Count == 0)
				Assert.IsTrue(true);		//Untestable
			else
			{
				int orderableId = (int)dtData.Rows[0][TABLES.OrderableTest.OrderableTestId];

				bool retValue = BOL.OrderedTest.IsCprsOrderable(orderableId);
				Assert.IsTrue(retValue == false);
			}
		}

		[Test]
		public void GetTestResultsForTask_Pass()
		{
			DataTable dtTest = BOL.OrderedTest.GetTestResultsForTask(this._tstOT.OrderedTestGuid);
			Assert.IsTrue(dtTest.Rows.Count >= 0);
			
		}

		[Test]
		public void GetTestResultsForTask_Fail()
		{
			DataTable dtTest = BOL.OrderedTest.GetTestResultsForTask(System.Guid.NewGuid());
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetHistoricalTestResultsForOrderedTest_Pass()
		{
			DataTable dtTest = this._tstOT.GetHistoricalTestResultsForOrderedTest();
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}
		
		
		[Test]
		public void GetHistoricalTestResultsForOrderedTest_Fail()
		{
			this._tstOT.OrderedTestGuid = System.Guid.NewGuid();

			DataTable dtTest = this._tstOT.GetHistoricalTestResultsForOrderedTest();
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void CheckForExpiredSpecimen_Pass()
		{
			this._tstOT.Specimen.SpecimenExpirationDate = System.DateTime.Now;

			bool retValue = this._tstOT.CheckForExpiredSpecimen(System.DateTime.Now.AddMinutes(-1));
			Assert.IsTrue(retValue);
		}
		
		[Test]
		public void CheckForExpiredSpecimen_Fail()
		{
			this._tstOT.Specimen.SpecimenExpirationDate = System.DateTime.Now;

			bool retValue = this._tstOT.CheckForExpiredSpecimen(System.DateTime.Now.AddMinutes(1));
			Assert.IsTrue(retValue == false);
		}

		[Test]
		public void CheckIfISOnlyXMatchPossible_Pass()
		{
			this.RefreshData = true;

            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.IsTrue(patientGuid == Guid.NewGuid());
				return;
			}
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            string CPRSOrderNumber = DataCreator.GetNewCprsOrderNumber();
			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderGroupNumber + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderReceivedDatetime + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + CPRSOrderNumber + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO PATIENTSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertOrderedTest += "'119',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'N',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid TRGuid = Guid.NewGuid();
			string insertTransfusionReq = "INSERT INTO PATIENTTRANSFUSIONREQUIREMENT (";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.PatientGuid + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.TransfusionRequirementText + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.CreateDate + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.CreateUser + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.CreateDivisionCode + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.VistaConversionIndicator + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.AntibodyTypeId + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.RecordStatusCode + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.LastUpdateDate + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.LastUpdateUser + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.LastUpdateFunctionId + ")";
			insertTransfusionReq += "VALUES (";
			insertTransfusionReq += "'" + TRGuid.ToString() + "',";
			insertTransfusionReq += "'" + patientGuid.ToString() + "',";
			insertTransfusionReq += "'Anti-C',";
			insertTransfusionReq += "'AS',";
			insertTransfusionReq += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertTransfusionReq += "'" + Environment.UserName + "',";
			insertTransfusionReq += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertTransfusionReq += "'0',";
			insertTransfusionReq += "'5',";
			insertTransfusionReq += "'A',";  //TR entered in VBECS
			insertTransfusionReq += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertTransfusionReq += "'" + Environment.UserName + "',";
			insertTransfusionReq += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidABS = Guid.NewGuid();
			string insertOrderedTestABS = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestABS += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestABS += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestABS += "VALUES (";
			insertOrderedTestABS += "'" + orderedTestGuidABS.ToString() + "',";
			insertOrderedTestABS += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestABS += "'3',";
			insertOrderedTestABS += "'A',";
			insertOrderedTestABS += "'P',";
            insertOrderedTestABS += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedTestABS += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestABS += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestABS += "'UnitTestUser',";
			insertOrderedTestABS += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid specimenTestGuid = Guid.NewGuid();
			string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
			insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertSpecimenTest += "VALUES (";
			insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
			insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertSpecimenTest += "'" + orderedTestGuidABS.ToString() + "',";
			insertSpecimenTest += "'52',";
			insertSpecimenTest += "'N',"; //negative ABS result
			insertSpecimenTest += "'A',";
			insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertSpecimenTest += "'UnitTestUser',";
			insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertOrderedTest);
			UnitTestUtil.RunSQL(insertTransfusionReq);
			UnitTestUtil.RunSQL(insertOrderedTestABS);
			UnitTestUtil.RunSQL(insertSpecimenTest);

			DataTable dtTests = OrderedTest.GetTestingTaskList(CPRSOrderNumber);
			DataRow[] drTests = dtTests.Select("OrderedTestGuid = '" + orderedTestGuid.ToString() + "'");
			if (drTests.Length > 0)
			{
				BOL.OrderedTest test = new BOL.OrderedTest(drTests[0]);

				Assert.IsTrue(test.CheckIfISOnlyXMatchPossible() == false);
			}

			string deleteTRs = "DELETE FROM PATIENTTRANSFUSIONREQUIREMENT WHERE PATIENTGUID = '" + patientGuid.ToString() + "'";

			UnitTestUtil.RunSQL(deleteTRs);
		}
		
		[Test]
		public void CheckIfISOnlyXMatchPossible_Pass2()
		{
			this.RefreshData = true;

            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.IsTrue(patientGuid == Guid.NewGuid());
				return;
			}
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            string CPRSOrderNumber = DataCreator.GetNewCprsOrderNumber();
			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderGroupNumber + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderReceivedDatetime + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + CPRSOrderNumber + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO PATIENTSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertOrderedTest += "'119',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'N',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid TRGuid = Guid.NewGuid();
			string insertTransfusionReq = "INSERT INTO PATIENTTRANSFUSIONREQUIREMENT (";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.PatientGuid + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.TransfusionRequirementText + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.CreateDate + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.CreateUser + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.CreateDivisionCode + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.VistaConversionIndicator + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.AntibodyTypeId + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.RecordStatusCode + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.LastUpdateDate + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.LastUpdateUser + ",";
			insertTransfusionReq += TABLES.PatientTransfusionRequirement.LastUpdateFunctionId + ")";
			insertTransfusionReq += "VALUES (";
			insertTransfusionReq += "'" + TRGuid.ToString() + "',";
			insertTransfusionReq += "'" + patientGuid.ToString() + "',";
			insertTransfusionReq += "'Anti-C',";
			insertTransfusionReq += "'AS',";
			insertTransfusionReq += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertTransfusionReq += "'" + Environment.UserName + "',";
			insertTransfusionReq += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertTransfusionReq += "'0',";
			insertTransfusionReq += "'5',";
			insertTransfusionReq += "'C',";  //TR from conversion
			insertTransfusionReq += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertTransfusionReq += "'" + Environment.UserName + "',";
			insertTransfusionReq += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidABS = Guid.NewGuid();
			string insertOrderedTestABS = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestABS += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestABS += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestABS += "VALUES (";
			insertOrderedTestABS += "'" + orderedTestGuidABS.ToString() + "',";
			insertOrderedTestABS += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestABS += "'3',";
			insertOrderedTestABS += "'A',";
			insertOrderedTestABS += "'P',";
            insertOrderedTestABS += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedTestABS += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestABS += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestABS += "'UnitTestUser',";
			insertOrderedTestABS += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid specimenTestGuid = Guid.NewGuid();
			string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
			insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertSpecimenTest += "VALUES (";
			insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
			insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertSpecimenTest += "'" + orderedTestGuidABS.ToString() + "',";
			insertSpecimenTest += "'52',";
			insertSpecimenTest += "'N',"; //negative ABS result
			insertSpecimenTest += "'A',";
			insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertSpecimenTest += "'UnitTestUser',";
			insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertOrderedTest);
			UnitTestUtil.RunSQL(insertTransfusionReq);
			UnitTestUtil.RunSQL(insertOrderedTestABS);
			UnitTestUtil.RunSQL(insertSpecimenTest);

			DataTable dtTests = OrderedTest.GetTestingTaskList(CPRSOrderNumber);
			DataRow[] drTests = dtTests.Select("OrderedTestGuid = '" + orderedTestGuid.ToString() + "'");
			if (drTests.Length > 0)
			{
				BOL.OrderedTest test = new BOL.OrderedTest(drTests[0]);

				Assert.IsTrue(test.CheckIfISOnlyXMatchPossible() == false);
			}

			string deleteTRs = "DELETE FROM PATIENTTRANSFUSIONREQUIREMENT WHERE PATIENTGUID = '" + patientGuid.ToString() + "'";

			UnitTestUtil.RunSQL(deleteTRs);
		}

		[Test]
		public void CheckIfISOnlyXMatchPossible_Pass3()
		{
			this.RefreshData = true;

            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(),"Patient does not exist");
				return;
			}
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            string CPRSOrderNumber = DataCreator.GetNewCprsOrderNumber();
			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderGroupNumber + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderReceivedDatetime + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + CPRSOrderNumber + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO PATIENTSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertOrderedTest += "'119',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'N',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidABS = Guid.NewGuid();
			string insertOrderedTestABS = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestABS += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestABS += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestABS += "VALUES (";
			insertOrderedTestABS += "'" + orderedTestGuidABS.ToString() + "',";
			insertOrderedTestABS += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestABS += "'3',";
			insertOrderedTestABS += "'A',";
			insertOrderedTestABS += "'P',";
            insertOrderedTestABS += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedTestABS += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestABS += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestABS += "'UnitTestUser',";
			insertOrderedTestABS += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid specimenTestGuid = Guid.NewGuid();
			string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
			insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertSpecimenTest += "VALUES (";
			insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
			insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertSpecimenTest += "'" + orderedTestGuidABS.ToString() + "',";
			insertSpecimenTest += "'52',";
			insertSpecimenTest += "'P',"; //positive ABS result
			insertSpecimenTest += "'A',";
			insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertSpecimenTest += "'UnitTestUser',";
			insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertOrderedTest);
			UnitTestUtil.RunSQL(insertOrderedTestABS);
			UnitTestUtil.RunSQL(insertSpecimenTest);

			DataTable dtTests = OrderedTest.GetTestingTaskList(CPRSOrderNumber);
			DataRow[] drTests = dtTests.Select("OrderedTestGuid = '" + orderedTestGuid.ToString() + "'");
			if (drTests.Length > 0)
			{
				BOL.OrderedTest test = new BOL.OrderedTest(drTests[0]);

				Assert.IsTrue(test.CheckIfISOnlyXMatchPossible() == false);
			}
		}

		[Test]
		public void CheckIfISOnlyXMatchPossible_Pass4()
		{
			this.RefreshData = true;

            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.IsTrue(patientGuid == Guid.NewGuid());
				return;
			}
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            string CPRSOrderNumber = DataCreator.GetNewCprsOrderNumber();
			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderGroupNumber + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderReceivedDatetime + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + CPRSOrderNumber + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO PATIENTSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertOrderedTest += "'119',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'N',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidABS = Guid.NewGuid();
			string insertOrderedTestABS = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestABS += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestABS += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestABS += "VALUES (";
			insertOrderedTestABS += "'" + orderedTestGuidABS.ToString() + "',";
			insertOrderedTestABS += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestABS += "'3',";
			insertOrderedTestABS += "'A',";
			insertOrderedTestABS += "'P',";
            insertOrderedTestABS += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
			insertOrderedTestABS += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestABS += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestABS += "'UnitTestUser',";
			insertOrderedTestABS += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid specimenTestGuid = Guid.NewGuid();
			string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
			insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertSpecimenTest += "VALUES (";
			insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
			insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertSpecimenTest += "'" + orderedTestGuidABS.ToString() + "',";
			insertSpecimenTest += "'52',";
			insertSpecimenTest += "'N',"; //negative ABS result
			insertSpecimenTest += "'A',";
			insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertSpecimenTest += "'UnitTestUser',";
			insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertOrderedTest);
			UnitTestUtil.RunSQL(insertOrderedTestABS);
			UnitTestUtil.RunSQL(insertSpecimenTest);

			DataTable dtTests = OrderedTest.GetTestingTaskList(CPRSOrderNumber);
			DataRow[] drTests = dtTests.Select("OrderedTestGuid = '" + orderedTestGuid.ToString() + "'");
			if (drTests.Length > 0)
			{
				BOL.OrderedTest test = new BOL.OrderedTest(drTests[0]);

				Assert.IsTrue(test.CheckIfISOnlyXMatchPossible() == true);
			}
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CheckIfISOnlyXMatchPossible_Fail()
		{
		}

		[Test]
		public void GetOrderedTests_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientSpecimenGuid];

			DataTable dtTest = BOL.OrderedTest.GetOrderedTests(unitGuid);
			Assert.IsTrue(dtTest.Rows.Count >= 0);		
		}
		
		[Test]
		public void GetOrderedTests_Fail()
		{
			DataTable dtTest = BOL.OrderedTest.GetOrderedTests(System.Guid.NewGuid());
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		
		[Test]
		public void GetTestOrders_Guid_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientSpecimenGuid];

			DataTable dtTest = BOL.OrderedTest.GetTestOrders(unitGuid);
			Assert.IsTrue(dtTest.Rows.Count >= 0);		
		}
		
		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetTestOrders_Guid_Fail()
		{
			BOL.OrderedTest.GetTestOrders(System.Guid.Empty);
		}

		[Test]
		public void GetSpecimenTestResultsForOrderedTest_Guid_Pass()
		{
			System.Collections.ArrayList alTest = BOL.OrderedTest.GetSpecimenTestResultsForOrderedTest(this._tstOT.OrderedTestGuid);
			Assert.IsNotNull(alTest);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetSpecimenTestResultsForOrderedTest_Guid_Fail()
		{
			BOL.OrderedTest.GetSpecimenTestResultsForOrderedTest(Guid.Empty);
		}

		[Test]
		public void GetSpecimenTestResultsForOrderedTest_Guid_Int_Pass()
		{
			System.Collections.ArrayList alTest = BOL.OrderedTest.GetSpecimenTestResultsForOrderedTest(this._tstOT.OrderedTestGuid, this._tstOT.ReportableTestId);
			Assert.IsNotNull(alTest);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetSpecimenTestResultsForOrderedTest_Guid_Int_Fail()
		{
			BOL.OrderedTest.GetSpecimenTestResultsForOrderedTest(Guid.Empty, Int32.MinValue);
		}

		[Test]
		public void GetBloodUnitTestResultsForOrderedTest_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];

			System.Collections.ArrayList alTest = BOL.OrderedTest.GetBloodUnitTestResultsForOrderedTest(this._tstOT.OrderedTestGuid, unitGuid);
			Assert.IsNotNull(alTest);
		}

		[Test]
		public void GetBloodUnitTestResultsForOrderedTest_Fail()
		{
			try
			{
				BOL.OrderedTest.GetBloodUnitTestResultsForOrderedTest(Guid.Empty, Guid.NewGuid());
				Assert.IsTrue(false, AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}

			try
			{
				BOL.OrderedTest.GetBloodUnitTestResultsForOrderedTest(Guid.NewGuid(), Guid.Empty);
				Assert.IsTrue(false, AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}

		}

		[Test]
		public void GetRequiredOrders_Pass()
		{
			System.DateTime tstDate = System.DateTime.Now.AddYears(-1);
			int tstHours = 24;
	
			DataTable dtTest = BOL.OrderedTest.GetRequiredOrders(UnitTestConfig.TestDivisionCode,tstHours, tstDate);
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		public void GetRequiredOrders_Fail()
		{
			System.DateTime tstDate = System.DateTime.Now.AddYears(-1);
			int tstHours = 24;
	
			DataTable dtTest = BOL.OrderedTest.GetRequiredOrders("Booger",tstHours, tstDate);
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetOrdersWithSpecimenInBloodBank_Pass()
		{
			DateTime tstDate = System.DateTime.Now.AddYears(-1);
			DataTable dtTest = BOL.OrderedTest.GetOrdersWithSpecimenInBloodBank(UnitTestConfig.TestDivisionCode, tstDate);
		
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		public void GetOrdersWithSpecimenInBloodBank_Fail()
		{
			DateTime tstDate = System.DateTime.Now.AddYears(-1);
			DataTable dtTest = BOL.OrderedTest.GetOrdersWithSpecimenInBloodBank("Weeee!", tstDate);
		
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetNewOrders_Pass()
		{
			DateTime tstDate = System.DateTime.Now.AddYears(-1);
			DataTable dtTest = BOL.OrderedTest.GetNewOrders(UnitTestConfig.TestDivisionCode, tstDate);
			
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		public void GetNewOrders_Fail()
		{
			DateTime tstDate = System.DateTime.Now.AddYears(1);
			DataTable dtTest = BOL.OrderedTest.GetNewOrders(UnitTestConfig.TestDivisionCode, tstDate);
			
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}


		[Test]
		public void GetOrderAlerts_Pass()
		{
			DateTime tstDate = System.DateTime.Now.AddYears(-1);
			DataTable dtTest = BOL.OrderedTest.GetOrderAlerts(tstDate);
			
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		public void GetOrderAlerts_Fail()
		{
			DateTime tstDate = System.DateTime.Now.AddYears(1);
			DataTable dtTest = BOL.OrderedTest.GetOrderAlerts(tstDate);
			
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetRecentTestOrders_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientSpecimenGuid];

			DataSet dsTest = BOL.OrderedTest.GetRecentTestOrders(unitGuid);
			Assert.IsNotNull(dsTest);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetRecentTestOrders_Fail()
		{
			BOL.OrderedTest.GetRecentTestOrders(Guid.Empty);
		}

		[Test]
		public void GetRecentTestOrdersCount_Pass()
		{
			System.Guid patientGuid = (System.Guid)this._dtPatientSpecimen.Rows[0][TABLES.PatientSpecimen.PatientSpecimenGuid];

			Assert.IsTrue(BOL.OrderedTest.GetRecentTestOrdersCount(patientGuid)>=0);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetRecentTestOrdersCount_Fail()
		{
			Assert.IsTrue(BOL.OrderedTest.GetRecentTestOrdersCount(Guid.Empty)==0);
		}

		[Test]
		public void StillActive_Pass()
		{
			StringBuilder query = new StringBuilder( "SELECT TOP 1 * FROM OrderedTest " );
			query.Append( "JOIN PatientOrder ON OrderedTest.PatientOrderGuid = PatientOrder.PatientOrderGuid " );
			query.Append( "JOIN PatientTreatment ON PatientOrder.PatientTreatmentGuid = PatientTreatment.PatientTreatmentGuid " );
			query.Append( "JOIN Patient ON PatientTreatment.PatientGuid = Patient.PatientGuid " );
			query.Append( "WHERE PatientOrder.OrderReceivedDatetime IS NOT NULL " );
			query.Append( "AND OrderedTest.OrderStatusCode <> 'X'" );
			//
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( query.ToString() );
			//
			BOL.OrderedTest ot = new BOL.OrderedTest( dr );
			//
			Common.OrderStatus status = Common.Utility.GetOrderStatusCodeFromString
				(
				DAL.OrderedTest.GetOrderedTest( ot.OrderedTestGuid ).Rows[0][TABLES.OrderedTest.OrderStatusCode].ToString()	
				);
			//
			Assert.IsTrue( ot.StillActive );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void StillActive_Fail()
		{
		}

		[Test]
		public void GetTestResultsWithErrorForTask_Pass()
		{
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( "SELECT TOP 1 S.OrderedTestGuid FROM SpecimenTest S" );
			//
			Guid orderedTestGuid = (Guid)dr[TABLES.OrderedTest.OrderedTestGuid];
			//
			UnitTestUtil.RunSQL("UPDATE SpecimenTest SET RecordStatusCode = 'E' WHERE OrderedTestGuid = '" + orderedTestGuid.ToString() + "'");

			dr = UnitTestUtil.RunSQLGetDataRow( "SELECT TOP 1 S.OrderedTestGuid FROM SpecimenTest S WHERE (S.RecordStatusCode = 'E' OR S.RecordStatusCode = 'X')" );
			//
			orderedTestGuid = (Guid)dr[TABLES.OrderedTest.OrderedTestGuid];
			//
			DataTable dt = BOL.OrderedTest.GetTestResultsWithErrorForTask( orderedTestGuid );
			//
			Assert.IsTrue( dt.Rows.Count > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTestResultsWithErrorForTask_Fail()
		{
		}

		[Test]
		public void GetEmergencyIssuedUnitsForOrderedTest_Pass()
		{
			StringBuilder query = new StringBuilder( "SELECT TOP 1 OrderedTest.OrderedTestGuid FROM OrderedUnit " );
			query.Append( "JOIN BloodUnitStatus ON BloodUnitStatus.BloodUnitGuid = OrderedUnit.BloodUnitGuid " );
			query.Append( "JOIN BloodUnitStatusCodeCurrent ON BloodUnitStatusCodeCurrent.BloodUnitGuid = OrderedUnit.BloodUnitGuid " );
			query.Append( "JOIN OrderedComponent ON OrderedComponent.OrderedComponentGuid = OrderedUnit.OrderedComponentGuid " );
			query.Append( "JOIN PatientOrder ON PatientOrder.PatientOrderGuid = OrderedComponent.PatientOrderGuid " );
			query.Append( "JOIN OrderedTest ON OrderedTest.PatientOrderGuid = PatientOrder.PatientOrderGuid " );
			query.Append( "WHERE (BloodUnitStatusCodeCurrent.UnitStatusCode = 'I'  OR BloodUnitStatusCodeCurrent.UnitStatusCode = 'T') " );
			//
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( query.ToString() );
			//
			Guid orderedTestGuid = (Guid)dr[TABLES.OrderedTest.OrderedTestGuid];
			//
			DataTable dt = BOL.OrderedTest.GetEmergencyIssuedUnitsForOrderedTest( orderedTestGuid );
			//
			Assert.IsTrue( dt.Rows.Count > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmergencyIssuedUnitsForOrderedTest_Fail()
		{
		}

		[Test]
		public void GetOrderedTest_Pass()
		{
			StringBuilder query = new StringBuilder( "SELECT TOP 1 OrderedTestGuid FROM OrderedUnit WHERE OrderedTestGuid IS NOT NULL " );
			//
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( query.ToString() );
			//
			Guid orderedTestGuid = (Guid)dr[TABLES.OrderedTest.OrderedTestGuid];
			//
			DataTable dt = BOL.OrderedTest.GetOrderedTest( orderedTestGuid );
			//
			Assert.IsTrue( dt.Rows.Count > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderedTest_Fail()
		{
		}

		[Test]
		public void CheckForRepeatAboRhDiscrepancy_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient");
			Guid patientGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'1',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'P',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid specimenTestGuid = Guid.NewGuid();
			string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
			insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
			insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
			insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertSpecimenTest += "VALUES (";
			insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
			insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
			insertSpecimenTest += "'" + orderedTestGuid.ToString() + "',";
			insertSpecimenTest += "'18',";
			insertSpecimenTest += "'A',";
			insertSpecimenTest += "'A',";
			insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertSpecimenTest += "'UnitTestUser',";
			insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid specimenTestGuid2 = Guid.NewGuid();
			string insertSpecimenTest2 = "INSERT INTO SPECIMENTEST (";
			insertSpecimenTest2 += TABLES.SpecimenTest.SpecimenTestGuid + ",";
			insertSpecimenTest2 += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
			insertSpecimenTest2 += TABLES.SpecimenTest.OrderedTestGuid + ",";
			insertSpecimenTest2 += TABLES.SpecimenTest.BloodTestTypeId + ",";
			insertSpecimenTest2 += TABLES.SpecimenTest.TestResultId + ",";
			insertSpecimenTest2 += TABLES.SpecimenTest.RecordStatusCode + ",";
			insertSpecimenTest2 += TABLES.PatientSpecimen.DivisionCode + ",";
			insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertSpecimenTest2 += "VALUES (";
			insertSpecimenTest2 += "'" + specimenTestGuid2.ToString() + "',";
			insertSpecimenTest2 += "'" + patientSpecimenGuid.ToString() + "',";
			insertSpecimenTest2 += "'" + orderedTestGuid.ToString() + "',";
			insertSpecimenTest2 += "'21',";
			insertSpecimenTest2 += "'P',";
			insertSpecimenTest2 += "'A',";
			insertSpecimenTest2 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertSpecimenTest2 += "'UnitTestUser',";
			insertSpecimenTest2 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedTest);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertSpecimenTest);
			UnitTestUtil.RunSQL(insertSpecimenTest2);
			
			bool retValue = false;
			
			try
			{
				string previousABO = "";
				string previousRh = "";
				DataTable dt = new DataTable();
				this._tstOT.RelatedTestGuid = orderedTestGuid;
				retValue = this._tstOT.CheckForRepeatAboRhDiscrepancy("B", "N", ref previousABO, ref previousRh, ref dt);
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM SPECIMENTEST WHERE SPECIMENTESTGUID = '" + specimenTestGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM SPECIMENTEST WHERE SPECIMENTESTGUID = '" + specimenTestGuid2.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM dbo.PatientSPECIMEN WHERE PatientSPECIMENGUID = '" + patientSpecimenGuid.ToString() + "'");
			}

			Assert.IsTrue(retValue);

		}

		[Test]
		public void CheckForRepeatAboRhDiscrepancy_Fail()
		{
			string a = string.Empty;
			string b = string.Empty;
			DataTable dt = new DataTable();
			//
			bool result = this._tstOT.CheckForRepeatAboRhDiscrepancy( string.Empty, string.Empty, ref a, ref b, ref dt );
			//
			Assert.IsTrue( !result );
		}
	}
}
#endif
